@extends('layouts.master')
@section('title',__('Create Package Feature'))
@section('breadcum')
  <div class="breadcrumbbar">
      <h4 class="page-title">{{ __('Create Package Feature') }}</h4>
      <div class="breadcrumb-list">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="{{url('/admin')}}" title="{{ __('Dashboard') }}">{{ __('Dashboard') }}</a></li>
            <li class="breadcrumb-item active" aria-current="page">{{ __('Create Package Feature') }}</li>
          </ol>
      </div>
  </div>
@endsection
@section('maincontent')
<div class="contentbar">
  <div class="row">
    @if ($errors->any())  
  <div class="alert alert-danger" role="alert">
  @foreach($errors->all() as $error)     
  <p>{{ $error}}<button type="button" class="close" data-dismiss="alert" aria-label="Close" title="{{ __('Close') }}">
  <span aria-hidden="true" style="color:red;">&times;</span></button></p>
      @endforeach  
  </div>
  @endif
    <div class="col-lg-12">
      <div class="card m-b-50">
        <div class="card-header">
          <a href="{{url('admin/package_feature')}}" class="float-right btn btn-primary-rgba mr-2" title="{{ __('Back') }}"><i
            class="feather icon-arrow-left mr-2"></i>{{ __('Back') }}</a>
          <h5 class="box-title">{{__('Create Package Features')}}</h5>
        </div>
        <div class="card-body ml-2">
          {!! Form::open(['method' => 'POST', 'action' => 'PackageFeatureController@store', 'files' => true]) !!}
            <div class="row">
              <div class="col-md-4">
                <div class="form-group">
                  <label for="name">
                    {{ __('Package Feature') }}:
                    <sup class="text-danger">*</sup>
                  </label>
                  <small class="badge badge-pill badge-secondary" data-toggle="tooltip" data-placement="top" title="" data-original-title="{{ __('Package feature will use for packages.') }}">
                    <i class="fa fa-info"></i>
                  </small>
                  
                  <input value="{{ old('name') }}" autofocus required name="name" type="text" class="form-control"
                    placeholder="{{ __('Please enter package feature') }}" />
                </div>
              </div>
            </div>
              <div class="form-group">
                <button type="reset" class="btn btn-success-rgba" title="{{__('Reset')}}">{{__('Reset')}}</button>
                <button type="submit" class="btn btn-primary-rgba" title="{{ __('Create') }}"><i class="fa fa-check-circle"></i>
                  {{ __('Create') }}</button>
              </div>
                {!! Form::close() !!}
                <div class="clear-both"></div>

      </div>
    </div>
  </div>
</div>
</div>
@endsection 
@section('script')
<script>
  (function($){
    $.noConflict();    
  })(jQuery);    
</script>
    
@endsection